﻿using Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ZSMusic.IDAL;
using ZSMusic.Model;

namespace ZSMusic.DAL.Platforms
{
    public class kw : IMusic
    {
        public List<Music> Search(string word, int page, int num)
        {
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get(string.Format("http://search.kuwo.cn/r.s?client=kt&all={0}&pn={1}&rn={2}&ft=music&plat=pc&cluster=1&result=json&rformat=json&ver=mbox&show_copyright_off=1&vipver=MUSIC_8.1.2.0_W4&encoding=utf8", word, page - 1, num));
            string[] infos = StringEx.GetMiddleTextMultiple(src, "{'AA", "tpay");
            foreach (string i in infos)
            {
                Music s = new Music();
                s.Id = StringEx.GetMiddleText(i, "MUSIC_", "','MUTI_VER");
                s.Name = StringEx.GetMiddleText(i, "NAME':'", "','NEW");
                s.Album = StringEx.GetMiddleText(i, "ALBUM':'", "','ALBUMID");
                s.Artist = StringEx.GetMiddleText(i, "ARTIST':'", "','ARTISTID");
                s.Source = "kw";
                s.ToString();
                list.Add(s);
            }
            return list;
        }

        public List<Music> SearchCollection(string id)
        {
            throw new NotSupportedException("该平台暂未支持歌单解析");
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get("https://www.kuwo.cn/playlist_detail/" + id);



            return list;
        }

        public List<Music> SearchAlbum(string id)
        {
            throw new NotImplementedException();
        }

        public bool GetData(Music m, string type = "all")
        {
            switch (type)
            {
                case "all":
                    GetPic(m);
                    GetLrc(m);
                    return GetUrl(m);
                case "url":
                    return GetUrl(m);
                case "pic":
                    return GetPic(m);
                case "lrc":
                    return GetLrc(m);
                default:
                    throw new NotImplementedException();
            }
        }
        //41369386
        //41369386
        private bool GetUrl(Music m)
        {
            m.Url = HttpHelper.Get("https://antiserver.kuwo.cn/anti.s?response=url&type=convert_url&br=320kmp3&format=mp3&rid=" + m.Id);
            return HttpHelper.CheckUri(m.Url);
        }

        private bool GetLrc(Music m)
        {
            qq dal = new qq();
            List<Music> list = dal.Search(string.Format("{0} {1}", m.Artist, m.Name), 1, 5);
            if (list.Count > 0)
            {
                dal.GetLrc(list[0]);
                m.Lrc = list[0].Lrc;
                //m.Lrc = Lyric.ParseKuwo(m.Id).Export;
            }
            return !string.IsNullOrWhiteSpace(m.Lrc);
        }

        private bool GetPic(Music m)
        {
            m.PicUrl = HttpHelper.Get("http://artistpicserver.kuwo.cn/pic.web?type=rid_pic&pictype=url&size=120&rid=" + m.Id);
            return HttpHelper.CheckUri(m.PicUrl);
        }
    }
}